close all
clear all
path(pathdef); % resets path to default path

addpath ./functions/

load ../../'Estimation Results'/Benchmark_Model.mat

cd ./dynare_codes/

%% Get Benchmark Variance Decomposition
Model_Moments(parameters, N_variables, N_ll); 
evalc('dynare World_Economy_Cartel_VD');

VD_no_fracking = oo_.variance_decomposition;

%% Get Fracking Variance Decomposition

exo_param.beta    = beta;
exo_param.epsilon = epsilon;
exo_param.alpha   = alpha;
exo_param.eta     = eta;
exo_param.psi     = psi;
exo_param.lambda  = lambda;
exo_param.nu      = nu;
exo_param.delta   = delta;
exo_param.gamma   = gamma;
exo_param.G_n     = G_n;
exo_param.G_o     = G_o;
exo_param.s_o     = s_o;
exo_param.varphi  = varphi;
exo_param.xi      = xi;

% Getting Fracking parameters

exo_param.eta_f   = 2.23;
exo_param.lambda_f= 1;
MS_f              = 0.2030704;

evalc('th_n_ss = fsolve( @(tt) calibrate_ss_resid_fracking(tt, exo_param, MS_f), 0.03);');
[resid, struct_param, endo_ss, phis] = calibrate_ss_resid_fracking(th_n_ss, exo_param, MS_f);

save calibration_parameters struct_param shock_param endo_ss

evalc('dynare World_Economy_Cartel_Fracking_VD.mod');
VD_fracking = oo_.variance_decomposition;

cd ../

disp(' ')
disp('Table 12: Variance decomposition')
disp(' ')
disp('                   No fracking           Fracking')
disp('Moment           Demand   Supply      Demand   Supply')
disp('-----------------------------------------------------')
disp(['dp:               '  num2str((VD_no_fracking(1, 2)), '%.1f') '%' ...
                     '    ' num2str((VD_no_fracking(1, 1)), '%.1f') '%' ...
                  '       ' num2str((VD_fracking(1, 2)), '%.1f') '%' ...
                     '    ' num2str((VD_fracking(1, 1)), '%.1f') '%'])
disp(['di:               '  num2str((VD_no_fracking(2, 2)), '%.3f') '%' ...
                     '   ' num2str((VD_no_fracking(2, 1)), '%.3f') '%' ...
                  '     ' num2str((VD_fracking(2, 2)), '%.3f') '%' ...
                     '  ' num2str((VD_fracking(2, 1)), '%.3f') '%'])
disp(['dq:               '  num2str((VD_no_fracking(3, 2)), '%.1f') '%' ...
                     '    ' num2str((VD_no_fracking(3, 1)), '%.1f') '%' ...
                  '       ' num2str((VD_fracking(3, 2)), '%.1f') '%' ...
                     '    ' num2str((VD_fracking(3, 1)), '%.1f') '%'])                 


